<?php

/*
Plugin Name: WP Vimeo Video Integration
Description: Integrates Vimeo videos into your WordPress site.
Author: Vovance
Author URI: https://vovance.com
Version: 1.0.0
Text Domain: wp-vimeo-video
*/

// Activation Hook: Create credentials table and search page
function custom_credentials_plugin_activate() {
    // Database table creation code goes here (replace with your logic)
    global $wpdb;
    $table_name = $wpdb->prefix . 'wp_vimeo_credentials';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE $table_name (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        authorization_token varchar(255) NOT NULL,
        authorization_id mediumint(9) NOT NULL,
        PRIMARY KEY  (id)
    ) $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);

    // Create the search page
    $search_page_id = wp_insert_post(array(
        'post_title'   => 'Search Vimeo Video',
        'post_content' => '[search_vimeo_video]', // Use a shortcode for content
        'post_status'  => 'publish',
        'post_type'    => 'page',
    ));

    // Save the page ID for later reference
    update_option('search_vimeo_page_id', $search_page_id);
}
register_activation_hook(__FILE__, 'custom_credentials_plugin_activate');

// Enqueue Bootstrap for styling
function enqueue_bootstrap() {
    wp_enqueue_style('bootstrap-css', 'https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css');
    wp_enqueue_script('bootstrap-js', 'https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js', array('jquery'), null, true);
}
add_action('wp_enqueue_scripts', 'enqueue_bootstrap');

// Function to create the credentials page in the admin menu
function add_credentials_menu() {
    add_menu_page(
        'Credentials Page',           // Page Title
        'Credentials',                // Menu Title
        'manage_options',             // Capability
        'vimeo-credentials',           // Menu Slug
        'vimeo_credentials_page',     // Callback function to display page content
        'dashicons-admin-generic'     // Icon for the menu item (optional)
    );
}
add_action('admin_menu', 'add_credentials_menu');

// Function to display the credentials page
function vimeo_credentials_page() {
    if (isset($_POST['save_credentials'])) {
        // Handle the form submission here and save the authorization token
        $authorization_token = sanitize_text_field($_POST['authorization_token']);
        $user_id = sanitize_text_field($_POST['authorization_id']);
        $curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://api.vimeo.com/oauth/verify',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'Authorization: Bearer '.$authorization_token,
    'Cookie: __cf_bm=3Naqzlc55mLH.YEtxVHc65zkiHH0PpqF5PfvWUF8WTg-1697715534-0-Ad03fxSDsbKqQkQq4obk4eTJCWGiJxznetNpl46RLe7b0VSWMGf7Y760iUm5LKdLUXM7D3iUDZXLpJqE2aKR1ac='
  ),
));

$response = curl_exec($curl);

curl_close($curl);
$response= json_decode($response,true);
if(isset($response['error']) && $response['error'] != '') { 
    update_option('vimeo_authorization_token', '');
    update_option('vimeo_authorization_id', '');
    $error_message = $response['error'];
    echo '<div class="alert alert-danger" style="background:red;color:#fff;padding: 15px;">'.$error_message.'</div>';
}
else{
    update_option('vimeo_authorization_token', $authorization_token);
    update_option('vimeo_authorization_id', $user_id);

    echo '<div class="alert alert-success" style="background:green;color:#fff;padding: 15px;">Credentials saved successfully!</div>';
}


       
    }
    ?>
    <div class="container mt-4">
        <h2 class="mb-4">Credentials Page</h2>
        <form method="post" action="">
            <div class="form-group">
                <label for="authorization_token">Authorization Token:</label>
                <input type="text" class="form-control" name="authorization_token" id="authorization_token" value="<?php echo esc_attr(get_option('vimeo_authorization_token')); ?>">
            </div>
            <div class="form-group">
                <label for="authorization_token">User Id:</label>
                <input type="text" class="form-control" name="authorization_id" id="authorization_id" value="<?php echo esc_attr(get_option('vimeo_authorization_id')); ?>">
            </div>
            <button type="submit" name="save_credentials" class="btn btn-primary mt-2">Save Credentials</button>
        </form>
    </div>
    <?php
}

// Function to create the search page in the admin menu
function add_search_videos_page() {
    $page_title = 'Search Vimeo Video';
    $menu_title = 'Search Vimeo Video';
    $capability = 'manage_options';
    $menu_slug = 'search-vimeo-video';
    $function = 'display_search_videos_page';
    $icon_url = 'dashicons-search'; // Change the icon as needed
    $position = 5;

    add_menu_page($page_title, $menu_title, $capability, $menu_slug, $function, $icon_url, $position);
}
$authorization_token = get_option('vimeo_authorization_token');

if (empty($authorization_token)) {

}
else{
    add_action('admin_menu', 'add_search_videos_page');

}

// Function to display the search page
function display_search_videos_page() {
    $authorization_token = get_option('vimeo_authorization_token');

    if (empty($authorization_token)) {
        // No valid credentials, redirect to the credentials page
        wp_safe_redirect(admin_url('admin.php?page=vimeo-credentials'));
        exit;
    }

    // Valid credentials exist, display the search page
    include(plugin_dir_path(__FILE__) . 'vimeo-search-page.php');
}


// Function to create a shortcode for the search page
function search_vimeo_video_shortcode() {
    ob_start();
    include(plugin_dir_path(__FILE__) . 'vimeo-search-page.php');
    return ob_get_clean();
}
add_shortcode('search_vimeo_video', 'search_vimeo_video_shortcode');

